<?php
 /**
 * @package Stripe Editor Button System plugin
 * @author Riccardo Zorn code@fasterjoomla.com
 * @Copyright (C) 2012 https://www.fasterjoomla.com
 * @license GNU/GPL v2 or greater http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin; // extends CMSPlugin replaces JPlugin
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

/**
 * Editor STRIPE button
 */
class plgButtonStripe_xtd extends CMSPlugin
{ 

	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}


	/**
	 * Display the button
	 *
	 * @return the $button object)
	 */
	function onDisplay($name)
	{
		/*
		 * Javascript to insert the shortcode
		 */
		$modalTitle = $name;
		$js = "
		function insertStripe(formattedStripe) {
			var tag = '<div>'+formattedStripe+'</div>';
			jInsertEditorText(tag, '".$name."');
			SqueezeBox.close();
		}
		function closeBox() {
			SqueezeBox.close();
		}

		";

		$doc = Factory::getDocument();
		$doc->addScriptDeclaration($js);

		$doc->addStyleDeclaration('.icon-stripe {
			background: url(/plugins/system/stripe_button/assets/images/s14.png) !important;
			background-repeat: no-repeat !important;
			
		}');

		$app = Factory::getApplication();
		$tmpl = $app->getTemplate();
		$doc->addStyleDeclaration(".button2-left .arsitem {background: url(templates/$tmpl/images/j_button2_readmore.png) 100% 0 no-repeat;}");
		/*
		 * Use the built-in element view to select the article.
		 * Currently uses blank class.
		 */
		$link = '../plugins/editors-xtd/stripe_xtd/modal.html';
 		
		if(version_compare(JVERSION,'4.0.0') < 0){
					JHtml::_('behavior.modal');
					$button = new JObject();
					$button->set('modal', true);
					$button->set('class', 'btn');
					$button->set('link', $link);
					$button->set('text', 'STRIPE');//Text::_('PLG_STRIPE_BUTTON_TEXT'));
					$button->set('name', 'stripe');
					$button->set('options', "{handler: 'iframe', size: {x: 770, y: 400}}");
					return $button;  
		} else {
			/*
			*
			* Test 4
			* copy from content editors_xtd
			*/
			$button          = new JObject;
			$button->modal   = true;
			$button->class   = 'btn';
			$button->link    = $link;
			$button->text    = htmlentities($modalTitle);//Text::_('PLG_EDITORS-XTD_CONTACT_BUTTON_CONTACT');
			$button->name    = 'stripeb';
			$button->title    = 'stripet';
			$button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";

			return $button;

		}
	}
}
